---
title: Glossary · Cloudflare Spectrum docs
description: Review the definitions for terms used across Cloudflare's Spectrum
  documentation.
lastUpdated: 2024-08-13T19:56:56.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/spectrum/glossary/
  md: https://developers.cloudflare.com/spectrum/glossary/index.md
---

Review the definitions for terms used across Cloudflare's Spectrum documentation.

| Term | Definition |
| - | - |
| ACK (Acknowledge) | The final step in the TCP three-way handshake, confirming the establishment of a connection. |
| FTP (File Transfer Protocol) | A standard network protocol used for transferring files from one host to another over a TCP-based network. |
| FTPS (File Transfer Protocol Secure) | An extension of FTP that adds support for the Transport Layer Security (TLS) or Secure Sockets Layer (SSL) cryptographic protocols. |
| layer 3 | The network layer in the OSI model, responsible for logical addressing, routing, and forwarding of data between devices on different networks. |
| layer 4 | The transport layer in the OSI model, managing end-to-end communication, error-checking, and flow control. |
| MQTT (Message Queuing Telemetry Transport) | A lightweight, publish-subscribe messaging protocol often used for communication in the Internet of Things (IoT) and other resource-constrained scenarios. |
| OSI model (Open Systems Interconnection model) | A conceptual framework that standardizes the functions of a telecommunication or computing system into seven abstraction layers. |
| proxy protocol | A protocol used by network proxies to convey client connection information to the destination server, facilitating proper handling of client requests. |
| reverse proxy | A server that handles requests on behalf of clients, forwarding them to backend servers and managing tasks like load balancing and security. |
| SFTP (Secure File Transfer Protocol) | A secure file transfer protocol that uses the Secure Socket Shell (SSH) protocol for encryption and authentication. |
| SMTP Server (Simple Mail Transfer Protocol Server) | A server responsible for sending, receiving, and relaying email messages over a network, following the SMTP protocol. |
| SYN (Synchronize) | The initial step in establishing a TCP connection, where a device requests a connection with another by sending a SYN packet. |
| SYN-ACK (Synchronize-Acknowledge) | The second step in the TCP three-way handshake, where the server responds to a SYN request with a SYN-ACK packet. |
| TCP (Transmission Control Protocol) | A connection-oriented protocol in the transport layer of the Internet Protocol Suite, providing reliable and ordered delivery of data between devices. |
| UDP (User Datagram Protocol) | UDP (User Datagram Protocol) is a connectionless transport layer protocol that provides fast and lightweight data transmission between devices on a network, prioritizing speed over reliability. |
