---
title: Role scopes · Cloudflare Fundamentals docs
description: Scopes are one of three constituent parts of a policy that allows
  granting of access to users.
lastUpdated: 2025-10-02T22:18:32.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/fundamentals/manage-members/scope/
  md: https://developers.cloudflare.com/fundamentals/manage-members/scope/index.md
---

Scopes are one of three constituent parts of a policy that allows granting of access to users.

To allow for flexible combinations of access to users, Cloudflare currently has two types of scopes (Account and Domain), with different sets of roles for each scope.

***

## Choose the scope of roles

Each policy has a limitation of a single scope, but you can assign multiple policies to a given user.

You can choose the scope of a policy when you [add a member](https://developers.cloudflare.com/fundamentals/manage-members/manage/).

### Account scope

If you want the member to have a policy that applies across your account, use the following combination of fields.

| Field | Value |
| - | - |
| Operator | *Include* |
| Type | *All domains* |

Note

You can only assign [account-scoped roles](https://developers.cloudflare.com/fundamentals/manage-members/roles/#account-scoped-roles) as part of these types of policies

### Specific Domains

If you want the member to have a policy that applies to a specific domain, use the following combination of fields. When applying these roles to this policy, only domain-scoped roles can be used.

| Field | Value |
| - | - |
| Operator | *Include* |
| Type | *A specific domain* |
| Name | *A specific domain* |

### Domain groups

If you have a set of domains that are all categorized similarly (e.g. all of your sensitive/production domains, all domains around a given project or geography), you can pre-assign them into a domain group and then create policies that provide access to all domains within this group.

#### Create group

To create a domain group:

1. In the Cloudflare dashboard, go to the **Settings** > **Lists** page. (You must be logged in as a **Super Administrator** and have a [verified email address](https://developers.cloudflare.com/fundamentals/user-profiles/verify-email-address/)).

   [Go to **Settings**](https://dash.cloudflare.com/?to=/:account/configurations)

2. For **Domain Group Manager**, select **Create**.

3. Create your domain group:

   1. Select the domains to include.
   2. Add a **Name**.
   3. Select **Create**.

You can also edit and delete these groups as needed.

#### Use group

To assign a member permissions to a domain group, use the following combination of fields:

| Field | Value |
| - | - |
| Operator | *Include* |
| Type | *Domain Group* |
| Name | *Example Group* |

Note

With Domain Groups, you can only assign [domain-scoped roles](https://developers.cloudflare.com/fundamentals/manage-members/roles/#domain-scoped-roles) to these members.

### Specific Resources

If you want the member to have a policy that applies to a specific resource, use the following combination of fields.

| Field | Value |
| - | - |
| Operator | *Include* |
| Type | *Granular* |
| Product | *Product Name* |
| Resource | *Specific Resource* |
